<?php

use App\Jobs;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();
Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
});
Route::get('/home', 'HomeController@index')->name('home');
Route::get('add_updates', 'HomeController@addupdates')->name('add_updates');

Route::get('logout', 'Auth\LoginController@logout');

Route::get('jobs_list', 'JobsController@index')->name('jobs_list');
Route::get('jobs/{id}', 'JobsController@jobsbytag')->name('jobs');

Route::get('new_job', 'JobsController@newjob')->name('new_job');
Route::get('update_view/{id}', 'JobsController@updateview')->name('update_view');
Route::get('update_job', 'JobsController@updatejob')->name('update_job');
Route::post('store_job', 'JobsController@storejob')->name('store_job');
Route::get("images/{id}", "JobsController@getImages");
// Route::get('delete_view','JobsController@deleteview')->name('delete_view');
Route::get('delete_job/{id}', 'JobsController@deletejob')->name('delete_job');
Route::get('update_status_view', 'JobsController@updatestatusview')->name('update_status_view');
Route::get('update_job_status', 'JobsController@updatejobstatus')->name('update_job_status');
Route::get('update_multi_job_status', 'JobsController@updatemultijobstatus')->name('update_multi_job_status');

Route::get('permissions', 'HomeController@permissions')->name('permissions');
Route::get('/update', 'HomeController@permissionsupdate')->name('updatepermissions');

Route::get('new_user', 'HomeController@newuser')->name('new_user');
Route::get('store_user', 'HomeController@storeuser')->name('store_user');

Route::get('profile', 'HomeController@profile')->name('profile');
Route::post('update_profile', 'HomeController@updateprofile')->name('update_profile');
Route::get('calender_show', 'HomeController@calender_show')->name('calender_show');
Route::get('/export/{id}', 'HomeController@export');
/* Route::get('/export', function () {
    echo "<script>window.close();</script>";
}); */
Route::get('pending/{id}/{status}', 'JobsController@index2')->name('pending_job');
Route::get('jobs_by', 'JobsController@index3')->name('jobs_by_date');
Route::get('getdate/{date}', 'JobsController@getdate');

Route::get('getdatecalender/{date}', 'JobsController@getdatecalender')->name('getdatecalender');

Route::get("bookingStatus", "JobsController@statusBookingUpdate");
Route::get("/exportList", "JobsController@exportList")->name("exportList");
Route::get("/exportView", "JobsController@exportView")->name("exportView");
Route::get("/monthly/jobs/{id}", "JobsController@preCurrWeek");

Route::get("/download/image/{id}", "JobsController@downloadImage")->name("download");
Route::get("/installer/note/{id}/{note}", "JobsController@installerNote");


Route::get("/hmo/new_flat/{id}", "JobsController@addnewflat")->name('addnewflat');



Route::get('/check', function () {

    $j = Jobs::where();
    
});
